﻿/// <reference name="MicrosoftAjax.js">

function checkAmounts() {
    var fromAmount = $find("FromCurrencyTextBox");
    var toAmount = $find("ToCurrencyTextBox");
    
    // using the unformatted values, reformat them into numbers and compare them.
    var unFormattedFrom = fromAmount.get_unFormattedValue();
    var unFormattedTo = toAmount.get_unFormattedValue();
    
    // make sure the values are set.
    var formattedFrom = null;
    var formattedTo = null;
    
    if (unFormattedFrom !== null && unFormattedFrom !== "") {
        formattedFrom = Number.parseLocale(unFormattedFrom);
        if (isNaN(formattedFrom)) {
            alert (String.format(Filter.Res.InvalidCurrencyFilterMessage, Filter.Res.FromAmount));
            return false;
        }
    }
    
    if (unFormattedTo !== null && unFormattedTo !== "") {
        formattedTo = Number.parseLocale(unFormattedTo);
        if (isNaN(formattedTo))
        {
            alert (String.format(Filter.Res.InvalidCurrencyFilterMessage, Filter.Res.ToAmount));
            return false;
        }
    }
        
    // make sure they are both valid dates
    if (formattedFrom !== null && formattedTo !== null) {
        if (formattedFrom > formattedTo) {
            alert (Filter.Res.FromAmountGreaterThanToAmountMessage);
            return false;
        }
    }
  
    return true;
}
Type.registerNamespace("Filter");
Filter.Res = {
    FromAmount: "De Cantidad",
    InvalidCurrencyFilterMessage: "El filtro no puede ser aplicado porque ' {0} ' no es un número válido.",
    ToAmount: "A la Cantidad",
    FromAmountGreaterThanToAmountMessage: "De cantidad debe estar menos que o el igual al a ascender."
};